!Object constantsFor: 'Geos Libraries'!

geosLIB35 'SYSTEM\mailbox'! !

!Object constantsFor: 'Geos vardata'!

hintMailboxSendControlIncorporateAddressControl 27648!
hintMailboxSendControlSeparateAddressControl 27652!
tempMailboxSendControlCurrentDialog 27656!
tempMailboxSendControlDestroyDialogPending 27660!
attrMailboxSendControlSendPages 27664!
attrMailboxSendControlSendDocument 27668!
attrMailboxSendControlSendSelection 27672!
attrMailboxSendControlTransportHint 27676!
attrMailboxSendControlTransportHintOptr 27676!
attrMailboxSendControlSingleTransport 27680!
tempMailboxSendControlAddressesAndTransport 27684!
attrMailboxSendControlAvailableFormats 27688!
attrMailboxSendControlSavesTransactions 27692!
!

!Object constantsFor: 'Geos messages'!

setPage 27136!
setBytes 27137!
setup 27136!
getMonikerString 27137!
setProgress 27138!
hideThyself 27139!
detachThread 27140!
reset 27136!
setProgress 27137!
addressControlSetMedium 27648!
addressControlGetAddresses 27649!
addressControlSetAddresses 27650!
addressControlGetTransData 27651!
addressControlMessageCanceled 27652!
addressControlTweakParams 27653!
addressControlAddRef 27654!
addressControlDelRef 27655!
addressControlSetValidState 27656!
addressControlCreateMessage 27657!
addressControlGetTransmitMoniker 27658!
addressControlSetValidAction 27659!
addressControlSetTransportDriver 27660!
addressControlProcessTransportHint 27661!
addressControlMessageRegistered 27662!
addressControlValidateAddresses 27663!
addressControlBodyAvailable 27664!
addressControlGetFeedbackString 27665!
addressControlGetFeedbackGlyph 27666!
addressControlCreateFeedback 27667!
outboxControlEnableFeatures 27648!
sendControlObjectTypeSelected 27648!
sendControlEnableDataObjectUi 27649!
sendControlGetPageRange 27650!
sendControlChooseFormat 27651!
sendControlCancelMessage 27652!
sendControlCreateTransaction 27653!
sendControlTweakParams 27654!
sendControlTransactionFinished 27655!
sendControlRegisterMessage 27656!
sendControlReplyToMessage 27657!
sendControlSetAddresses 27658!
sendControlSetAvailableFormats 27659!
sendControlGetObjectType 27660!
sendControlCreateBody 27661!
sendControlSetDataObjectValid 27662!
sendControlSaveTransaction 27663!
sendControlCompleteTransaction 27664!
sendControlGetAddresses 27693!
sendControlTransportSelected 27694!
sendControlInitiateDialogWithTransport 27695!
sendControlGetContentsMoniker 27696!
sendControlGetContentsString 27697!
sendControlSetContents 27698!
sendControlPoofSelected 27699!
printingComplete 28160!
printingCanceled 28161!
getPageRange 28162!
getObjectType 28163!
adjustAddress 28164!
getDriverType 28165!
modifyPrintControlAttrs 28166!
getExtraTopSpace 28167!
attachPrintControl 28168!
!

!Geos class methodsFor: 'library calls'!

MailboxReportProgress: type with: data with: action
	"void pascal MailboxReportProgress(MailboxProgressType type, dword data, MailboxProgressAction action) in internal/mboxint.goh"
	^GEOS call: type with: data with: action with: #[35 0 107 1 2 1 0]!

MailboxGetRemainingMessages
	"word pascal MailboxGetRemainingMessages(void) in internal/mboxint.goh"
	^GEOS call: #[35 0 134 1]!

MailboxGetRemainingDestinations: msg
	"dword pascal MailboxGetRemainingDestinations(MailboxMessage msg) in internal/mboxint.goh"
	^GEOS call: msg with: #[35 0 135 2 2]!

MailboxGetCancelFlag
	"word * pascal MailboxGetCancelFlag(void) in internal/mboxint.goh"
	^GEOS call: #[35 0 108 3]!

MailboxSetCancelAction: destination with: messageToSend
	"void pascal MailboxSetCancelAction(optr destination, Message messageToSend) in internal/mboxint.goh"
	^GEOS call: destination with: messageToSend with: #[35 0 118 2 1 0]!

MailboxRegisterMessage: mrmArgs with: msg
	"MailboxError pascal MailboxRegisterMessage(MailboxRegisterMessageArgs *mrmArgs, MailboxMessage *msg) in mailbox.goh"
	^GEOS call: mrmArgs with: msg with: #[35 0 92 3 3 1]!

MailboxGetAdminFile
	"VMFileHandle pascal MailboxGetAdminFile(void) in mailbox.goh"
	^GEOS call: #[35 0 125 1]!

MailboxGetVMFile: expectedNumBlocks with: vmStatusp
	"VMFileHandle pascal MailboxGetVMFile(word expectedNumBlocks, word *vmStatusp) in mailbox.goh"
	^GEOS call: expectedNumBlocks with: vmStatusp with: #[35 0 88 1 3 1]!

MailboxOpenVMFile: namep with: vmStatusp
	"VMFileHandle pascal MailboxOpenVMFile(FileLongName *namep, word *vmStatusp) in mailbox.goh"
	^GEOS call: namep with: vmStatusp with: #[35 0 89 3 3 1]!

MailboxGetVMFileName: file with: namep
	"void pascal MailboxGetVMFileName(VMFileHandle file, FileLongName *namep) in mailbox.goh"
	^GEOS call: file with: namep with: #[35 0 90 1 3 0]!

MailboxDoneWithVMFile: file
	"void pascal MailboxDoneWithVMFile(VMFileHandle file) in mailbox.goh"
	^GEOS call: file with: #[35 0 91 1 0]!

MailboxCheckMediumAvailable: mediumType with: unitNum with: unitType
	"Boolean pascal MailboxCheckMediumAvailable(MediumType mediumType, word unitNum, MediumUnitType unitType) in mailbox.goh"
	^GEOS call: mediumType with: unitNum with: unitType with: #[35 0 115 2 1 1 4]!

MailboxCheckMediumConnected: mediumType with: unitNum with: unitType
	"Boolean pascal MailboxCheckMediumConnected(MediumType mediumType, word unitNum, MediumUnitType unitType) in mailbox.goh"
	^GEOS call: mediumType with: unitNum with: unitType with: #[35 0 116 2 1 1 4]!

MailboxGetFirstMediumUnit: mediumType with: unitType
	"word pascal MailboxGetFirstMediumUnit(MediumType mediumType, MediumUnitType *unitType) in mailbox.goh"
	^GEOS call: mediumType with: unitType with: #[35 0 117 2 3 1]!

MailboxGetUserTransAddrLMem: msg with: addrNumber with: lmemBlock with: addrChunk
	"MailboxError pascal MailboxGetUserTransAddrLMem(MailboxMessage msg, word addrNumber, MemHandle lmemBlock, ChunkHandle *addrChunk) in mailbox.goh"
	^GEOS call: msg with: addrNumber with: lmemBlock with: addrChunk with: #[35 0 130 2 1 1 3 1]!

MailboxGetNumTransAddrs: msg with: numAddresses
	"MailboxError pascal MailboxGetNumTransAddrs(MailboxMessage msg, word *numAddresses) in mailbox.goh"
	^GEOS call: msg with: numAddresses with: #[35 0 106 2 3 1]!

MailboxGetTransAddr: msg with: addrNumber with: addressBuffer with: bufSizePtr
	"Boolean pascal MailboxGetTransAddr(MailboxMessage msg, word addrNumber, void *addressBuffer, word *bufSizePtr) in mailbox.goh"
	^GEOS call: msg with: addrNumber with: addressBuffer with: bufSizePtr with: #[35 0 105 2 1 3 3 4]!

MailboxSetTransAddr: msg with: addrNumber with: newAddress with: addrSize
	"MailboxError pascal MailboxSetTransAddr(MailboxMessage msg, word addrNumber, const void *newAddress, word addrSize) in mailbox.goh"
	^GEOS call: msg with: addrNumber with: newAddress with: addrSize with: #[35 0 104 2 1 3 1 1]!

MailboxGetTransData: msg with: transData
	"MailboxError pascal MailboxGetTransData(MailboxMessage msg, dword *transData) in mailbox.goh"
	^GEOS call: msg with: transData with: #[35 0 109 2 3 1]!

MailboxSetTransData: msg with: transData
	"MailboxError pascal MailboxSetTransData(MailboxMessage msg, dword transData) in mailbox.goh"
	^GEOS call: msg with: transData with: #[35 0 110 2 2 1]!

MailboxGetStorageType: msg with: storage
	"MailboxError pascal MailboxGetStorageType(MailboxMessage msg, MailboxStorage *storage) in mailbox.goh"
	^GEOS call: msg with: storage with: #[35 0 103 2 3 1]!

MailboxGetTransport: msg with: transport
	"MailboxError pascal MailboxGetTransport(MailboxMessage msg, MailboxTransport *transport) in mailbox.goh"
	^GEOS call: msg with: transport with: #[35 0 69 2 3 1]!

MailboxGetBodyMboxRefBlock: msg with: mboxRefHandle
	"MailboxError pascal MailboxGetBodyMboxRefBlock(MailboxMessage msg, MemHandle *mboxRefHandle) in mailbox.goh"
	^GEOS call: msg with: mboxRefHandle with: #[35 0 111 2 3 1]!

MailboxGetDestApp: msg with: tokenBuf
	"MailboxError pascal MailboxGetDestApp(MailboxMessage msg, GeodeToken *tokenBuf) in mailbox.goh"
	^GEOS call: msg with: tokenBuf with: #[35 0 102 2 3 1]!

MailboxGetStartBound: msg with: dateTime
	"MailboxError pascal MailboxGetStartBound(MailboxMessage msg, FileDateAndTime *dateTime) in mailbox.goh"
	^GEOS call: msg with: dateTime with: #[35 0 112 2 3 1]!

MailboxGetEndBound: msg with: dateTime
	"MailboxError pascal MailboxGetEndBound(MailboxMessage msg, FileDateAndTime *dateTime) in mailbox.goh"
	^GEOS call: msg with: dateTime with: #[35 0 113 2 3 1]!

MailboxAcknowledgeMessageReceipt: msg
	"void pascal MailboxAcknowledgeMessageReceipt(MailboxMessage msg) in mailbox.goh"
	^GEOS call: msg with: #[35 0 101 2 0]!

MailboxDeleteMessage: msg
	"void pascal MailboxDeleteMessage(MailboxMessage msg) in mailbox.goh"
	^GEOS call: msg with: #[35 0 114 2 0]!

MailboxGetSubjectLMem: msg with: lmemBlock with: subjectChunk
	"MailboxError pascal MailboxGetSubjectLMem(MailboxMessage msg, MemHandle lmemBlock, ChunkHandle *subjectChunk) in mailbox.goh"
	^GEOS call: msg with: lmemBlock with: subjectChunk with: #[35 0 99 2 1 3 1]!

MailboxGetSubjectBlock: msg with: subjHandle
	"MailboxError pascal MailboxGetSubjectBlock(MailboxMessage msg, MemHandle *subjHandle) in mailbox.goh"
	^GEOS call: msg with: subjHandle with: #[35 0 100 2 3 1]!

MailboxGetMessageFlags: msg with: flags
	"MailboxError pascal MailboxGetMessageFlags(MailboxMessage msg, MailboxMessageFlags *flags) in mailbox.goh"
	^GEOS call: msg with: flags with: #[35 0 98 2 3 1]!

MailboxGetBodyFormat: msg with: dataFormat
	"MailboxError pascal MailboxGetBodyFormat(MailboxMessage msg, MailboxDataFormat *dataFormat) in mailbox.goh"
	^GEOS call: msg with: dataFormat with: #[35 0 94 2 3 1]!

MailboxGetBodyRef: msg with: appRefBuf with: appRefBufSize
	"MailboxError pascal MailboxGetBodyRef(MailboxMessage msg, void *appRefBuf, word *appRefBufSize) in mailbox.goh"
	^GEOS call: msg with: appRefBuf with: appRefBufSize with: #[35 0 95 2 3 3 1]!

MailboxChangeBodyFormat: msg with: mcbfArgs
	"MailboxError pascal MailboxChangeBodyFormat(MailboxMessage msg, const MailboxChangeBodyFormatArgs *mcbfArgs) in mailbox.goh"
	^GEOS call: msg with: mcbfArgs with: #[35 0 93 2 3 1]!

MailboxBodyReformatted: msg with: newFormat with: newBodyFlags
	"MailboxError pascal MailboxBodyReformatted(MailboxMessage msg, MailboxDataFormat newFormat, MailboxMessageFlags newBodyFlags) in mailbox.goh"
	^GEOS call: msg with: newFormat with: newBodyFlags with: #[35 0 133 2 2 1 1]!

MailboxStealBody: msg with: appRefBuf with: appRefBufSize
	"MailboxError pascal MailboxStealBody(MailboxMessage msg, void *appRefBuf, word *appRefBufSize) in mailbox.goh"
	^GEOS call: msg with: appRefBuf with: appRefBufSize with: #[35 0 97 2 3 3 1]!

MailboxDoneWithBody: msg with: appRef with: appRefSize
	"void pascal MailboxDoneWithBody(MailboxMessage msg, const void *appRef, word appRefSize) in mailbox.goh"
	^GEOS call: msg with: appRef with: appRefSize with: #[35 0 96 2 3 1 0]!

MailboxLoadDataDriver: storage with: error
	"GeodeHandle pascal MailboxLoadDataDriver(MailboxStorage storage, GeodeLoadError *error) in mailbox.goh"
	^GEOS call: storage with: error with: #[35 0 120 2 3 1]!

MailboxLoadDataDriverWithError: storage with: error
	"GeodeHandle pascal MailboxLoadDataDriverWithError(MailboxStorage storage, GeodeLoadError *error) in mailbox.goh"
	^GEOS call: storage with: error with: #[35 0 121 2 3 1]!

MailboxLoadTransportDriver: transport with: error
	"GeodeHandle pascal MailboxLoadTransportDriver(MailboxTransport transport, GeodeLoadError *error) in mailbox.goh"
	^GEOS call: transport with: error with: #[35 0 119 2 3 1]!

MailboxFreeDriver: driverHandle
	"void pascal MailboxFreeDriver(GeodeHandle driverHandle) in mailbox.goh"
	^GEOS call: driverHandle with: #[35 0 122 1 0]!

MailboxPushToMailboxDir
	"void pascal MailboxPushToMailboxDir(void) in mailbox.goh"
	^GEOS call: #[35 0 78 0]!

MailboxChangeToMailboxDir
	"void pascal MailboxChangeToMailboxDir(void) in mailbox.goh"
	^GEOS call: #[35 0 79 0]!

MailboxConvertToMailboxTransferItem: clipboardFile with: clipboardBlock with: vmFile with: userID with: nameLMemBlock with: nameChunk with: transferItemBlock
	"void pascal MailboxConvertToMailboxTransferItem(VMFileHandle clipboardFile, VMBlockHandle clipboardBlock, VMFileHandle vmFile, word userID, MemHandle nameLMemBlock, ChunkHandle nameChunk, VMFileHandle *transferItemBlock) in mailbox.goh"
	^GEOS call: clipboardFile with: clipboardBlock with: vmFile with: userID with: nameLMemBlock with: nameChunk with: transferItemBlock with: #[35 0 123 1 1 1 1 1 1 3 0]!

MailboxConvertToClipboardTransferItem: mailboxFile with: mailboxBlock with: clipboardFile with: userID with: clipboardBlock
	"void pascal MailboxConvertToClipboardTransferItem(VMFileHandle mailboxFile, VMBlockHandle mailboxBlock, VMFileHandle clipboardFile, word userID, VMBlockHandle *clipboardBlock) in mailbox.goh"
	^GEOS call: mailboxFile with: mailboxBlock with: clipboardFile with: userID with: clipboardBlock with: #[35 0 124 1 1 1 1 3 0]!

MailboxReplyToMessage: mrtmArgs with: msg
	"MailboxError pascal MailboxReplyToMessage(MailboxReplyToMessageArgs *mrtmArgs, MailboxMessage *msg) in mailbox.goh"
	^GEOS call: mrtmArgs with: msg with: #[35 0 70 3 3 1]!

!

GenText subclass: #MailboxPages
	instanceVariableNames: ''
	classVariableNames: ''!

GenInteraction subclass: #MailboxProgressBox
	instanceVariableNames: ''
	classVariableNames: ''!

GenInteraction subclass: #MailboxProgressGauge
	instanceVariableNames: ''
	classVariableNames: ''!

GenControl subclass: #MailboxAddressControl
	instanceVariableNames: ''
	classVariableNames: ''!

GenControl subclass: #MailboxOutboxControl
	instanceVariableNames: ''
	classVariableNames: ''!

GenControl subclass: #MailboxSendControl
	instanceVariableNames: ''
	classVariableNames: ''!

MailboxAddressControl subclass: #MailboxSpoolAddressControl
	instanceVariableNames: ''
	classVariableNames: ''!

!MailboxPages comment!
Library mailbox, file internal/mboxint.goh! !

!MailboxPages class methodsFor: 'library linkage'!

library
	^35!

entry
	^36!
!

!MailboxPages methodsFor: 'Geos instance variables'!

!

!MailboxPages methodsFor: 'Geos vardata'!

!

!MailboxPages methodsFor: 'Geos messages'!

setPage: currentPage with: totalPages
	"@message void MSG_MP_SET_PAGE(word currentPage = cx, word totalPages = dx)"
	^self geosMessage: #[106 0 2 53 1 1 0] with: currentPage with: totalPages!

setBytes: num
	"@message void MSG_MP_SET_BYTES(dword num = cx:dx)"
	^self geosMessage: #[106 1 2 53 2 0] with: num!

!

!MailboxProgressBox comment!
Library mailbox, file internal/mboxint.goh! !

!MailboxProgressBox class methodsFor: 'library linkage'!

library
	^35!

entry
	^35!
!

!MailboxProgressBox methodsFor: 'Geos instance variables'!

mpbiProgressGauge
	"@instance ChunkHandle MPBI_progressGauge"
	^self wordAt: 21!

mpbiProgressGauge: value
	"@instance ChunkHandle MPBI_progressGauge"
	^self wordAt: 21 put: value!

mpbiThread
	"@instance ThreadHandle MPBI_thread"
	^self wordAt: 23!

mpbiThread: value
	"@instance ThreadHandle MPBI_thread"
	^self wordAt: 23 put: value!

mpbiGen
	"@instance word MPBI_gen"
	^self wordAt: 25!

mpbiGen: value
	"@instance word MPBI_gen"
	^self wordAt: 25 put: value!

mpbiType
	"@instance MPBType MPBI_type"
	^self wordAt: 27!

mpbiType: value
	"@instance MPBType MPBI_type"
	^self wordAt: 27 put: value!

!

!MailboxProgressBox methodsFor: 'Geos vardata'!

!

!MailboxProgressBox methodsFor: 'Geos messages'!

setup: args
	"@message void MSG_MPB_SETUP(MPBSetupArgs *args = ss:bp)"
	^self geosMessage: #[106 0 0 128 3 0] with: args!

getMonikerString: args
	"@message ChunkHandle MSG_MPB_GET_MONIKER_STRING(MPBSetupArgs *args = ss:bp)"
	^self geosMessage: #[106 1 0 128 3 1] with: args!

setProgress: args
	"@message void MSG_MPB_SET_PROGRESS(MPBSetProgressArgs *args = ss:bp)"
	^self geosMessage: #[106 2 0 128 3 0] with: args!

hideThyself
	"@message void MSG_MPB_HIDE_THYSELF()"
	^self geosMessage: #[106 3 2 0 0]!

detachThread
	"@message void MSG_MPB_DETACH_THREAD()"
	^self geosMessage: #[106 4 2 0 0]!

!

!MailboxProgressGauge comment!
Library mailbox, file internal/mboxint.goh! !

!MailboxProgressGauge class methodsFor: 'library linkage'!

library
	^35!

entry
	^34!
!

!MailboxProgressGauge methodsFor: 'Geos instance variables'!

mpgiText
	"@instance ChunkHandle MPGI_text"
	^self wordAt: 21!

mpgiText: value
	"@instance ChunkHandle MPGI_text"
	^self wordAt: 21 put: value!

mpgiPercent
	"@instance ChunkHandle MPGI_percent"
	^self wordAt: 23!

mpgiPercent: value
	"@instance ChunkHandle MPGI_percent"
	^self wordAt: 23 put: value!

mpgiPages
	"@instance ChunkHandle MPGI_pages"
	^self wordAt: 25!

mpgiPages: value
	"@instance ChunkHandle MPGI_pages"
	^self wordAt: 25 put: value!

mpgiGraphic
	"@instance ChunkHandle MPGI_graphic"
	^self wordAt: 27!

mpgiGraphic: value
	"@instance ChunkHandle MPGI_graphic"
	^self wordAt: 27 put: value!

mpgiBytes
	"@instance ChunkHandle MPGI_bytes"
	^self wordAt: 29!

mpgiBytes: value
	"@instance ChunkHandle MPGI_bytes"
	^self wordAt: 29 put: value!

!

!MailboxProgressGauge methodsFor: 'Geos vardata'!

!

!MailboxProgressGauge methodsFor: 'Geos messages'!

reset: destroy
	"@message void MSG_MPG_RESET(Boolean destroy = cx)"
	^self geosMessage: #[106 0 2 5 4 0] with: destroy!

setProgress: args
	"@message void MSG_MPG_SET_PROGRESS(MPBSetProgressArgs *args = ss:bp)"
	^self geosMessage: #[106 1 0 128 3 0] with: args!

!

!MailboxAddressControl comment!
Library mailbox, file internal/mboxint.goh! !

!MailboxAddressControl class methodsFor: 'library linkage'!

library
	^35!

entry
	^21!
!

!MailboxAddressControl methodsFor: 'Geos instance variables'!

maciRefCount
	"@instance word MACI_refCount"
	^self wordAt: 25!

maciRefCount: value
	"@instance word MACI_refCount"
	^self wordAt: 25 put: value!

maciValidDest
	"@instance optr MACI_validDest"
	^self dwordAt: 27!

maciValidDest: value
	"@instance optr MACI_validDest"
	^self dwordAt: 27 put: value!

maciValidMsg
	"@instance Message MACI_validMsg"
	^self wordAt: 31!

maciValidMsg: value
	"@instance Message MACI_validMsg"
	^self wordAt: 31 put: value!

maciDriver
	"@instance GeodeHandle MACI_driver"
	^self wordAt: 33!

maciDriver: value
	"@instance GeodeHandle MACI_driver"
	^self wordAt: 33 put: value!

maciDefaultAddrs
	"@instance ChunkHandle MACI_defaultAddrs"
	^self wordAt: 35!

maciDefaultAddrs: value
	"@instance ChunkHandle MACI_defaultAddrs"
	^self wordAt: 35 put: value!

!

!MailboxAddressControl methodsFor: 'Geos vardata'!

!

!MailboxAddressControl methodsFor: 'Geos messages'!

addressControlSetMedium: args
	"@message void MSG_MAILBOX_ADDRESS_CONTROL_SET_MEDIUM(MACSetMediumArgs *args = ss:bp)"
	^self geosMessage: #[108 0 0 128 3 0] with: args!

addressControlGetAddresses: transData
	"@message ChunkHandle MSG_MAILBOX_ADDRESS_CONTROL_GET_ADDRESSES(dword transData = cx:dx)= ax"
	^self geosMessage: #[108 1 98 53 2 1] with: transData!

addressControlSetAddresses: addr
	"@message void MSG_MAILBOX_ADDRESS_CONTROL_SET_ADDRESSES(optr addr = cx:dx)"
	^self geosMessage: #[108 2 2 53 2 0] with: addr!

addressControlGetTransData
	"@message dword MSG_MAILBOX_ADDRESS_CONTROL_GET_TRANS_DATA()= dx:ax"
	^self geosMessage: #[108 3 162 0 2]!

addressControlMessageCanceled: transData
	"@message void MSG_MAILBOX_ADDRESS_CONTROL_MESSAGE_CANCELED(dword transData = cx:dx)"
	^self geosMessage: #[108 4 2 53 2 0] with: transData!

addressControlTweakParams: mrmArgs
	"@message void MSG_MAILBOX_ADDRESS_CONTROL_TWEAK_PARAMS(MailboxRegisterMessageArgs *mrmArgs = cx:dx)"
	^self geosMessage: #[108 5 2 53 3 0] with: mrmArgs!

addressControlAddRef
	"@message void MSG_MAILBOX_ADDRESS_CONTROL_ADD_REF()"
	^self geosMessage: #[108 6 2 0 0]!

addressControlDelRef
	"@message void MSG_MAILBOX_ADDRESS_CONTROL_DEL_REF()"
	^self geosMessage: #[108 7 2 0 0]!

addressControlSetValidState: valid
	"@message void MSG_MAILBOX_ADDRESS_CONTROL_SET_VALID_STATE(Boolean valid = cx)"
	^self geosMessage: #[108 8 2 5 4 0] with: valid!

addressControlCreateMessage: reentrantPtr with: objType with: mscTransaction
	"@message Boolean MSG_MAILBOX_ADDRESS_CONTROL_CREATE_MESSAGE(Boolean *reentrantPtr = multipleax, MailboxObjectType objType = cx, optr mscTransaction = dx:bp)= carry"
	^self geosMessage: #[108 9 215 245 3 1 2 4] with: reentrantPtr with: objType with: mscTransaction!

addressControlGetTransmitMoniker
	"@message optr MSG_MAILBOX_ADDRESS_CONTROL_GET_TRANSMIT_MONIKER()= cx:dx"
	^self geosMessage: #[108 10 154 0 2]!

addressControlSetValidAction: notifOD with: mesg
	"@message void MSG_MAILBOX_ADDRESS_CONTROL_SET_VALID_ACTION(optr notifOD = cx:dx, Message mesg = bp)"
	^self geosMessage: #[108 11 3 245 2 1 0] with: notifOD with: mesg!

addressControlSetTransportDriver: driverHandle
	"@message void MSG_MAILBOX_ADDRESS_CONTROL_SET_TRANSPORT_DRIVER(GeodeHandle driverHandle = cx)"
	^self geosMessage: #[108 12 2 5 1 0] with: driverHandle!

addressControlProcessTransportHint: data with: hintBlock
	"@message void MSG_MAILBOX_ADDRESS_CONTROL_PROCESS_TRANSPORT_HINT(const void *data = cx:dx, MemHandle hintBlock = bp)"
	^self geosMessage: #[108 13 3 245 3 1 0] with: data with: hintBlock!

addressControlMessageRegistered: transData with: transHandle
	"@message void MSG_MAILBOX_ADDRESS_CONTROL_MESSAGE_REGISTERED(dword transData = cx:dx, ChunkHandle transHandle = bp)"
	^self geosMessage: #[108 14 3 245 2 1 0] with: transData with: transHandle!

addressControlValidateAddresses
	"@message Boolean MSG_MAILBOX_ADDRESS_CONTROL_VALIDATE_ADDRESSES()= carry"
	^self geosMessage: #[108 15 2 0 4]!

addressControlBodyAvailable: trans
	"@message void MSG_MAILBOX_ADDRESS_CONTROL_BODY_AVAILABLE(MSCTransaction * *trans = dx:bp)"
	^self geosMessage: #[108 16 2 62 3 0] with: trans!

addressControlGetFeedbackString
	"@message optr MSG_MAILBOX_ADDRESS_CONTROL_GET_FEEDBACK_STRING()= cx:dx"
	^self geosMessage: #[108 17 154 0 2]!

addressControlGetFeedbackGlyph
	"@message optr MSG_MAILBOX_ADDRESS_CONTROL_GET_FEEDBACK_GLYPH()= cx:dx"
	^self geosMessage: #[108 18 154 0 2]!

addressControlCreateFeedback: mscTransaction
	"@message void MSG_MAILBOX_ADDRESS_CONTROL_CREATE_FEEDBACK(optr mscTransaction = dx:bp)"
	^self geosMessage: #[108 19 2 62 2 0] with: mscTransaction!

!

!MailboxOutboxControl comment!
Library mailbox, file mailbox.goh! !

!MailboxOutboxControl class methodsFor: 'library linkage'!

library
	^35!

entry
	^126!
!

!MailboxOutboxControl methodsFor: 'Geos instance variables'!

!

!MailboxOutboxControl methodsFor: 'Geos vardata'!

!

!MailboxOutboxControl methodsFor: 'Geos messages'!

outboxControlEnableFeatures: normal with: toolbox
	"@message void MSG_MAILBOX_OUTBOX_CONTROL_ENABLE_FEATURES(MOCFeatures normal = cx, MOCToolboxFeatures toolbox = dx)"
	^self geosMessage: #[108 0 2 53 1 1 0] with: normal with: toolbox!

!

!MailboxSendControl comment!
Library mailbox, file mailbox.goh! !

!MailboxSendControl class methodsFor: 'library linkage'!

library
	^35!

entry
	^19!
!

!MailboxSendControl methodsFor: 'Geos instance variables'!

msciDataTypes
	"@instance ChunkHandle MSCI_dataTypes"
	^self wordAt: 25!

msciDataTypes: value
	"@instance ChunkHandle MSCI_dataTypes"
	^self wordAt: 25 put: value!

msciTransactions
	"@instance ChunkHandle MSCI_transactions"
	^self wordAt: 27!

msciTransactions: value
	"@instance ChunkHandle MSCI_transactions"
	^self wordAt: 27 put: value!

msciDefBodyType
	"@instance MailboxObjectType MSCI_defBodyType"
	^self wordAt: 29!

msciDefBodyType: value
	"@instance MailboxObjectType MSCI_defBodyType"
	^self wordAt: 29 put: value!

msciCurBodyType
	"@instance MailboxObjectType MSCI_curBodyType"
	^self wordAt: 31!

msciCurBodyType: value
	"@instance MailboxObjectType MSCI_curBodyType"
	^self wordAt: 31 put: value!

!

!MailboxSendControl methodsFor: 'Geos vardata'!

hintMailboxSendControlIncorporateAddressControl
	"@vardata void HINT_MAILBOX_SEND_CONTROL_INCORPORATE_ADDRESS_CONTROL"
	^self addVardata: ##hintMailboxSendControlIncorporateAddressControl!

hintMailboxSendControlSeparateAddressControl
	"@vardata void HINT_MAILBOX_SEND_CONTROL_SEPARATE_ADDRESS_CONTROL"
	^self addVardata: ##hintMailboxSendControlSeparateAddressControl!

tempMailboxSendControlCurrentDialog
	"@vardata TempMailboxDialogData TEMP_MAILBOX_SEND_CONTROL_CURRENT_DIALOG"
	^self addVardata: ##tempMailboxSendControlCurrentDialog size: 4!

tempMailboxSendControlCurrentDialog: aBlock
	"@vardata TempMailboxDialogData TEMP_MAILBOX_SEND_CONTROL_CURRENT_DIALOG"
	aBlock value: (GCSTempMailboxDialogData forPointer: (self addVardata: ##tempMailboxSendControlCurrentDialog size: 4)).!

tempMailboxSendControlDestroyDialogPending
	"@vardata void TEMP_MAILBOX_SEND_CONTROL_DESTROY_DIALOG_PENDING"
	^self addVardata: ##tempMailboxSendControlDestroyDialogPending!

attrMailboxSendControlSendPages
	"@vardata void ATTR_MAILBOX_SEND_CONTROL_SEND_PAGES"
	^self addVardata: ##attrMailboxSendControlSendPages!

attrMailboxSendControlSendDocument
	"@vardata void ATTR_MAILBOX_SEND_CONTROL_SEND_DOCUMENT"
	^self addVardata: ##attrMailboxSendControlSendDocument!

attrMailboxSendControlSendSelection
	"@vardata void ATTR_MAILBOX_SEND_CONTROL_SEND_SELECTION"
	^self addVardata: ##attrMailboxSendControlSendSelection!

attrMailboxSendControlTransportHint
	"@vardata MailboxTransportAndOption ATTR_MAILBOX_SEND_CONTROL_TRANSPORT_HINT"
	^self addVardata: ##attrMailboxSendControlTransportHint size: 6!

attrMailboxSendControlTransportHint: aBlock
	"@vardata MailboxTransportAndOption ATTR_MAILBOX_SEND_CONTROL_TRANSPORT_HINT"
	aBlock value: (GCSMailboxTransportAndOption forPointer: (self addVardata: ##attrMailboxSendControlTransportHint size: 6)).!

attrMailboxSendControlTransportHintOptr
	"@vardata MailboxTransportHintOptr ATTR_MAILBOX_SEND_CONTROL_TRANSPORT_HINT_OPTR"
	^self addVardata: ##attrMailboxSendControlTransportHintOptr size: 10!

attrMailboxSendControlTransportHintOptr: aBlock
	"@vardata MailboxTransportHintOptr ATTR_MAILBOX_SEND_CONTROL_TRANSPORT_HINT_OPTR"
	aBlock value: (GCSMailboxTransportHintOptr forPointer: (self addVardata: ##attrMailboxSendControlTransportHintOptr size: 10)).!

attrMailboxSendControlSingleTransport
	"@vardata MailboxMediaTransport ATTR_MAILBOX_SEND_CONTROL_SINGLE_TRANSPORT"
	^self addVardata: ##attrMailboxSendControlSingleTransport size: 10!

attrMailboxSendControlSingleTransport: aBlock
	"@vardata MailboxMediaTransport ATTR_MAILBOX_SEND_CONTROL_SINGLE_TRANSPORT"
	aBlock value: (GCSMailboxMediaTransport forPointer: (self addVardata: ##attrMailboxSendControlSingleTransport size: 10)).!

tempMailboxSendControlAddressesAndTransport
	"@vardata MSCAddressesAndTransport TEMP_MAILBOX_SEND_CONTROL_ADDRESSES_AND_TRANSPORT"
	^self addVardata: ##tempMailboxSendControlAddressesAndTransport size: 8!

tempMailboxSendControlAddressesAndTransport: aBlock
	"@vardata MSCAddressesAndTransport TEMP_MAILBOX_SEND_CONTROL_ADDRESSES_AND_TRANSPORT"
	aBlock value: (GCSMSCAddressesAndTransport forPointer: (self addVardata: ##tempMailboxSendControlAddressesAndTransport size: 8)).!

attrMailboxSendControlAvailableFormats
	"@vardata MailboxDataFormat[] ATTR_MAILBOX_SEND_CONTROL_AVAILABLE_FORMATS"
	^self addVardata: ##attrMailboxSendControlAvailableFormats size: 0!

attrMailboxSendControlSavesTransactions
	"@vardata void ATTR_MAILBOX_SEND_CONTROL_SAVES_TRANSACTIONS"
	^self addVardata: ##attrMailboxSendControlSavesTransactions!

!

!MailboxSendControl methodsFor: 'Geos messages'!

sendControlObjectTypeSelected: objType
	"@message void MSG_MAILBOX_SEND_CONTROL_OBJECT_TYPE_SELECTED(MailboxObjectType objType = cx)"
	^self geosMessage: #[108 0 2 5 1 0] with: objType!

sendControlEnableDataObjectUi: treeRoot
	"@message void MSG_MAILBOX_SEND_CONTROL_ENABLE_DATA_OBJECT_UI(optr treeRoot = cx:dx)"
	^self geosMessage: #[108 1 2 53 2 0] with: treeRoot!

sendControlGetPageRange: transHandle
	"@message dword MSG_MAILBOX_SEND_CONTROL_GET_PAGE_RANGE(word transHandle = bp)= cx:dx"
	^self geosMessage: #[108 2 154 7 1 2] with: transHandle!

sendControlChooseFormat: format with: transHandle
	"@message MailboxDataFormat MSG_MAILBOX_SEND_CONTROL_CHOOSE_FORMAT(MailboxDataFormat *format = cx:dx, word transHandle = bp)= cx:dx"
	^self geosMessage: #[108 3 155 245 3 1 2] with: format with: transHandle!

sendControlCancelMessage: transHandle with: notifyFlag
	"@message void MSG_MAILBOX_SEND_CONTROL_CANCEL_MESSAGE(word transHandle = bp, word notifyFlag = dx)"
	^self geosMessage: #[108 4 2 55 1 1 0] with: transHandle with: notifyFlag!

sendControlCreateTransaction
	"@message optr MSG_MAILBOX_SEND_CONTROL_CREATE_TRANSACTION()"
	^self geosMessage: #[108 5 2 0 2]!

sendControlTweakParams: mrmArgs with: transChunk
	"@message void MSG_MAILBOX_SEND_CONTROL_TWEAK_PARAMS(MailboxRegisterMessageArgs *mrmArgs = cx:dx, ChunkHandle transChunk = bp)"
	^self geosMessage: #[108 6 3 245 3 1 0] with: mrmArgs with: transChunk!

sendControlTransactionFinished: transChunk
	"@message void MSG_MAILBOX_SEND_CONTROL_TRANSACTION_FINISHED(ChunkHandle transChunk = bp)"
	^self geosMessage: #[108 7 2 7 1 0] with: transChunk!

sendControlRegisterMessage: mscRMArgs with: transHandle
	"@message void MSG_MAILBOX_SEND_CONTROL_REGISTER_MESSAGE(MSCRegisterMessageArgs *mscRMArgs = cx:dx, word transHandle = bp)= dx:ax"
	^self geosMessage: #[108 8 163 245 3 1 0] with: mscRMArgs with: transHandle!

sendControlReplyToMessage: msg
	"@message void MSG_MAILBOX_SEND_CONTROL_REPLY_TO_MESSAGE(MailboxMessage msg = cx:dx)"
	^self geosMessage: #[108 9 2 53 2 0] with: msg!

sendControlSetAddresses: mscsaArgs
	"@message void MSG_MAILBOX_SEND_CONTROL_SET_ADDRESSES(MSCSetAddressesArgs *mscsaArgs = cx:dx)"
	^self geosMessage: #[108 10 2 53 3 0] with: mscsaArgs!

sendControlSetAvailableFormats: formats
	"@message void MSG_MAILBOX_SEND_CONTROL_SET_AVAILABLE_FORMATS(const MailboxDataFormat *formats = cx:dx)"
	^self geosMessage: #[108 11 2 53 3 0] with: formats!

sendControlGetObjectType: transHandle
	"@message MailboxObjectType MSG_MAILBOX_SEND_CONTROL_GET_OBJECT_TYPE(word transHandle = bp)= ax"
	^self geosMessage: #[108 12 98 7 1 1] with: transHandle!

sendControlCreateBody: transHandle
	"@message void MSG_MAILBOX_SEND_CONTROL_CREATE_BODY(ChunkHandle transHandle= bp)"
	^self geosMessage: #[108 13 2 7 1 0] with: transHandle!

sendControlSetDataObjectValid: isValid
	"@message void MSG_MAILBOX_SEND_CONTROL_SET_DATA_OBJECT_VALID(Boolean isValid = cx)"
	^self geosMessage: #[108 14 2 5 4 0] with: isValid!

sendControlSaveTransaction: retVal with: destFile with: transHandle
	"@message Boolean MSG_MAILBOX_SEND_CONTROL_SAVE_TRANSACTION(word *retVal = multipleax, VMFileHandle destFile = cx, word transHandle = bp)= carry"
	^self geosMessage: #[108 15 214 61 3 1 1 4] with: retVal with: destFile with: transHandle!

sendControlCompleteTransaction: transHandle
	"@message void MSG_MAILBOX_SEND_CONTROL_COMPLETE_TRANSACTION(word transHandle = bp)"
	^self geosMessage: #[108 16 2 7 1 0] with: transHandle!

sendControlGetAddresses
	"@message void MSG_MAILBOX_SEND_CONTROL_GET_ADDRESSES()"
	^self geosMessage: #[108 45 2 0 0]!

sendControlTransportSelected: transIndex
	"@message void MSG_MAILBOX_SEND_CONTROL_TRANSPORT_SELECTED(word transIndex = cx)"
	^self geosMessage: #[108 46 2 5 1 0] with: transIndex!

sendControlInitiateDialogWithTransport: mediaTransport
	"@message void MSG_MAILBOX_SEND_CONTROL_INITIATE_DIALOG_WITH_TRANSPORT(@stack MailboxMediaTransport mediaTransport)"
	^self geosMessage: #[108 47 0 10 64 10 0] with: mediaTransport!

sendControlGetContentsMoniker: transIndex
	"@message void MSG_MAILBOX_SEND_CONTROL_GET_CONTENTS_MONIKER(word transIndex = cx)"
	^self geosMessage: #[108 48 2 5 1 0] with: transIndex!

sendControlGetContentsString: index with: lmemBlock
	"@message optr MSG_MAILBOX_SEND_CONTROL_GET_CONTENTS_STRING(word index = cx, MemHandle lmemBlock = dx)= dx:ax"
	^self geosMessage: #[108 49 162 53 1 1 2] with: index with: lmemBlock!

sendControlSetContents: index with: numSelections with: itemFlags
	"@message void MSG_MAILBOX_SEND_CONTROL_SET_CONTENTS(word index = cx, word numSelections = bp, GenItemGroupStateFlags itemFlags = dl)"
	^self geosMessage: #[108 50 2 253 1 1 1 0] with: index with: numSelections with: itemFlags!

sendControlPoofSelected: type
	"@message void MSG_MAILBOX_SEND_CONTROL_POOF_SELECTED(MailboxDialogType type=dx)"
	^self geosMessage: #[108 51 2 6 1 0] with: type!

!

!MailboxSpoolAddressControl comment!
Library mailbox, file internal/mboxint.goh! !

!MailboxSpoolAddressControl class methodsFor: 'library linkage'!

library
	^35!

entry
	^33!
!

!MailboxSpoolAddressControl methodsFor: 'Geos instance variables'!

msaciPc
	"@instance optr MSACI_pc"
	^self dwordAt: 37!

msaciPc: value
	"@instance optr MSACI_pc"
	^self dwordAt: 37 put: value!

msaciPcAttrs
	"@instance word MSACI_pcAttrs"
	^self wordAt: 41!

msaciPcAttrs: value
	"@instance word MSACI_pcAttrs"
	^self wordAt: 41 put: value!

msaciTrans
	"@instance ChunkHandle MSACI_trans"
	^self wordAt: 43!

msaciTrans: value
	"@instance ChunkHandle MSACI_trans"
	^self wordAt: 43 put: value!

!

!MailboxSpoolAddressControl methodsFor: 'Geos vardata'!

!

!MailboxSpoolAddressControl methodsFor: 'Geos messages'!

printingComplete: jobParams with: printControl
	"@message void MSG_MSAC_PRINTING_COMPLETE(MemHandle jobParams = cx, optr printControl = dx:bp)"
	^self geosMessage: #[110 0 3 245 1 2 0] with: jobParams with: printControl!

printingCanceled: printControl
	"@message void MSG_MSAC_PRINTING_CANCELED(optr printControl = dx:bp)"
	^self geosMessage: #[110 1 2 62 2 0] with: printControl!

getPageRange
	"@message dword MSG_MSAC_GET_PAGE_RANGE()= cx:dx"
	^self geosMessage: #[110 2 154 0 2]!

getObjectType
	"@message word MSG_MSAC_GET_OBJECT_TYPE()"
	^self geosMessage: #[110 3 2 0 1]!

adjustAddress: jobParams
	"@message void MSG_MSAC_ADJUST_ADDRESS(MemHandle jobParams = cx)"
	^self geosMessage: #[110 4 2 5 1 0] with: jobParams!

getDriverType
	"@message PrinterDriverType MSG_MSAC_GET_DRIVER_TYPE()= ax"
	^self geosMessage: #[110 5 98 0 1]!

modifyPrintControlAttrs: attrs
	"@message PrintControlAttrs MSG_MSAC_MODIFY_PRINT_CONTROL_ATTRS( PrintControlAttrs attrs = cx)= cx"
	^self geosMessage: #[110 6 102 5 1 1] with: attrs!

getExtraTopSpace
	"@message word MSG_MSAC_GET_EXTRA_TOP_SPACE()= dx"
	^self geosMessage: #[110 7 106 0 1]!

attachPrintControl
	"@message void MSG_MSAC_ATTACH_PRINT_CONTROL()"
	^self geosMessage: #[110 8 2 0 0]!

!

